/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.hamcrest.generator.EasyMock2FactoryWriter;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;

public class EasyMock2FactoryWriterTest
extends TestCase {
    private FactoryWriter factoryWriter;
    private StringWriter output = new StringWriter();

    protected void setUp() throws Exception {
        super.setUp();
        this.factoryWriter = new EasyMock2FactoryWriter((Writer)this.output, "com.blah", "EasyMatchers");
    }

    public void testWritesMethodDelegationMethodWrappedInAdapter() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "anyObject", "unusedReturnType");
        this.factoryWriter.writeMethod(method.getName(), method);
        EasyMock2FactoryWriterTest.assertEquals((String)"  public static java.lang.Object anyObject() {\n    org.hamcrest.integration.EasyMockAdapter.adapt(\n      com.example.MyMatcher.anyObject());\n    return null;\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesReturnType() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "anyString", "unusedReturnType");
        method.setGenerifiedType("String");
        this.factoryWriter.writeMethod(method.getName(), method);
        EasyMock2FactoryWriterTest.assertEquals((String)"  public static String anyString() {\n    org.hamcrest.integration.EasyMockAdapter.adapt(\n      com.example.MyMatcher.anyString());\n    return null;\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesAdvancedGenerifiedMatcherType() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "weirdThing", "unusedReturnType");
        method.setGenerifiedType("java.util.Map<com.Foo<Cheese>,?>");
        this.factoryWriter.writeMethod(method.getName(), method);
        EasyMock2FactoryWriterTest.assertEquals((String)"  public static java.util.Map<com.Foo<Cheese>,?> weirdThing() {\n    org.hamcrest.integration.EasyMockAdapter.adapt(\n      com.example.MyMatcher.weirdThing());\n    return null;\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesParameters() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "between", "unusedReturnType");
        method.addParameter("int[]", "lower");
        method.addParameter("com.blah.Cheesable<Long>...", "upper");
        this.factoryWriter.writeMethod(method.getName(), method);
        EasyMock2FactoryWriterTest.assertEquals((String)"  public static java.lang.Object between(int[] lower, com.blah.Cheesable<Long>... upper) {\n    org.hamcrest.integration.EasyMockAdapter.adapt(\n      com.example.MyMatcher.between(lower, upper));\n    return null;\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesExceptions() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "tricky", "unusedReturnType");
        method.addException("java.io.IOException");
        method.addException("com.foo.CheeselessException");
        this.factoryWriter.writeMethod(method.getName(), method);
        EasyMock2FactoryWriterTest.assertEquals((String)"  public static java.lang.Object tricky() throws java.io.IOException, com.foo.CheeselessException {\n    org.hamcrest.integration.EasyMockAdapter.adapt(\n      com.example.MyMatcher.tricky());\n    return null;\n  }\n\n", (String)this.output.toString());
    }
}

